function [Xt,Yt,Ra,Rb]=Vector_scalars(R,Req_d,A,B,X1,Y1)

% This function returns the mangnitude scalars Ra and Rb for both combined
% forces ae well as predicting the new position based on the particle
% current position. 


Req_d=wrapToPi(Req_d); % converting the required direction to Pi system
A=wrapToPi(A); % converting the first force direction to Pi system
B=wrapToPi(B); % converting the second force direction to Pi system
[Xd,Yd] = pol2cart(Req_d,R);% calculating the Cartesian distance between current and predicted positions. 
Xt=Xd+X1;Yt=Yd+Y1; % predicting the new position

% scalars Ra and Rb for the two combined forces
Ra=abs((Xd-((Yd*cos(B)*cos(A)-Xd*sin(A)*cos(B))/(sin(B-A))))/cos(A));
Rb=abs((Yd*cos(A)-Xd*sin(A))/(sin(B-A)));

